import java.io.IOException;

public class CreditCardAccount extends Account {
	
	private int creditLimit = -1000;
	private double interestRate = 0.0235;
	
	/** Constructor: Creates a credit card account with 0 balance (no money to spend, everything is negative) and an owner **/
	public CreditCardAccount(Person p, CreditCardCompany c){
		super(0.0, c, p);		
	}

    /**Pays money to a store from the account **/
	public void payTo(Store s, double amt){
		try {
			if( getOwner().requestPassword()){
				Transfer.transfer(this, s.getOwner(), amt);
			}
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
    }
    
	/**Modifier: Sets the credit limit to val **/
    public void setCreditLimit(int val){
    	creditLimit = val;
    }
    
    /**Accessor: Gets the credit limit**/
    public int getCreditLimit(){
    	return creditLimit;
    }


}
